/**
 * class to create object instance of theme for all widgets defined in template. It read theme XML file, and put styles into widgets during initialization these widgets.
 */
export class Debug {
	/**
	 * prints keays and values in console as a table, and prints trace
	 * @param {Array(String)} keys 		Array of keys to print in table
	 * @param {Array(string)} values 	Array of values to print in table
	 */
	static traceTable(keys, values, label = null) {
		if(label != null)
			console.groupCollapsed(label);
		if(Array.isArray(keys) && Array.isArray(values) && keys.length == values.length) {
			var table = {};
			for(var i = 0; i < keys.length; i++) {
				table[keys[i]] = values[i];
			}
			console.table(table);
		}
		else {
			console.log("Debug.traceTable() - invalid arguments!!!");
		}
		console.trace();
		if(label != null)
			console.groupEnd();
	}

	/**
	 * prints input's name and its value in console, and prints trace
	 * @param {*} input 	any variable to print
	 */
	static traceLog(input, label = null) {
		var keyName = Object.keys(input)[0];
		if(label != null)
			console.groupCollapsed(label);
		console.log(keyName + ": " + input[keyName]);
		console.trace();
		if(label != null)
			console.groupEnd();
	}
}